/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.blocks.rock_salt;

import com.ordana.spelunkery.blocks.rock_salt.RockSalt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class RockSaltBlock
extends Block
implements RockSalt {
    public RockSaltBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ILLUMINATED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIGHT, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        super.m_7926_(stateManager);
        stateManager.m_61104_(new Property[]{ILLUMINATED, LIGHT});
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.m_7731_(pos, RockSaltBlock.updateDistance(state, (LevelAccessor)level, pos), 3);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockState = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIGHT, (Comparable)Integer.valueOf(0))).m_61124_((Property)ILLUMINATED, (Comparable)Boolean.valueOf(false));
        return RockSaltBlock.updateDistance(blockState, (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        int i = RockSaltBlock.getDistanceAt(neighborState) - 1;
        if (i != 1 || (Integer)state.m_61143_((Property)LIGHT) != i) {
            level.m_186460_(currentPos, (Block)this, 1);
        }
        return state;
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        this.onEntityStepOn(state, entity);
        super.m_141947_(world, pos, state, entity);
    }

    private static BlockState updateDistance(BlockState state, LevelAccessor level, BlockPos pos) {
        Direction[] var5;
        int i = 0;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Direction direction : var5 = Direction.values()) {
            mutableBlockPos.m_122159_((Vec3i)pos, direction);
            i = Math.max(i, RockSaltBlock.getDistanceAt(level.m_8055_((BlockPos)mutableBlockPos)) - 1);
            if (i == 16) break;
        }
        return (BlockState)((BlockState)state.m_61124_((Property)LIGHT, (Comparable)Integer.valueOf(i))).m_61124_((Property)ILLUMINATED, (Comparable)Boolean.valueOf(i > 0));
    }

    private static int getDistanceAt(BlockState neighbor) {
        if (neighbor.m_60791_() > 1) {
            return neighbor.m_60791_();
        }
        return neighbor.m_61138_((Property)ILLUMINATED) ? (Integer)neighbor.m_61143_((Property)LIGHT) : 0;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)LIGHT);
    }
}

